//////////////////////////////////////////////////////////////////////////////////
//                                           Pleione : Engine for Mabinogi Project
//                                                                        CPLSElex
//
//                                       eias erinys fecit, begins at 2001. 06. 04
//                                          eias@nexon.co.kr, sheplany@nownuri.net
///////////////////////////////////////////////////////////// component of Pleione

elexfilename	= "PLS_Elex";
elexname		= CPLSElex;

include =
{*
//////////////////////////////////////////////////////////////////////////////////
//                                           Pleione : Engine for Mabinogi Project
//                                                                        CPLSElex
//
//                                       eias erinys fecit, begins at 2001. 06. 04
//                                          eias@nexon.co.kr, sheplany@nownuri.net
///////////////////////////////////////////////////////////// component of Pleione

#pragma warning(disable:4786)

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
*};

define =
{*
*};

PLS_LBRACE			{:#{:};
PLS_RBRACE			{:#}:};
PLS_LPAREN          {:#(:};
PLS_RPAREN          {:#):};

PLS_ASSIGN			{:=:};

PLS_COMMA			{:,:};
PLS_COLON			{:#::};

PLS_ADD				{:#+:};
PLS_SUBTRACT		{:#-:};
PLS_MULTIPLY		{:#*:};
PLS_DIVIDE			{:#/:};

PLS_GE				{:>=:};
PLS_GT				{:>:};
PLS_LE				{:<=:};
PLS_LT				{:<:};
PLS_EQ				{:==:};
PLS_NE				{:!=:};

PLS_NOT				{:{not}:};
PLS_OR				{:{or}:};
PLS_AND				{:{and}:};

PLS_STRING          {:#"#"~*#":}
{*
	int len = strlen(TEXT);
	char* pTemp = new char[len - 1];
	strncpy(pTemp, TEXT + 1, len - 2);
	pTemp[len - 2] = 0;
	SetText(pTemp);
	delete[] pTemp;
*};
PLS_TRUE			{:{true}:};
PLS_FALSE			{:{false}:};

PLS_INTEGER					{:0-9+:}
(value)
{*
	RETURN (void*) (atoi(TEXT));
*};
PLS_REAL            {:0-9+.0-9+:}
(value)
{*
	float fValue;

	fValue = (float)(atof(TEXT));

	RETURN (void*) (*((unsigned long*)(&fValue)));
*};

PLS_ID				{:[#_a-zA-Z][a-zA-z0-9$#_]*:};

//////////////////////////////////////////////////////////////////////////////////
// white spaces, remarks
//////////////////////////////////////////////////////////////////////////////////

PLS_WHITESPACE	(ignore)	{:[" "\t]+:};

PLS_NEWLINE		(ignore)	{:(\n?\r)|(\r?\n):}
{*
	NEWLINE;
*};

PLS_REMARKLINE	(ignore)	{://[\n\r]~*((\n?\r)|(\r?\n)):}
{*
	ELEX.NewRow();
*};

PLS_REMARK		(ignore)	{:/#*((/#*~)|([/*]~)|(#*/~))*#*/:}
{*
	const char* pText = GetText();
	int len = strlen(pText), i;

	for (i = 0; i < len; i++)
		// count new lines
		if (pText[i] == '\n')	ELEX.NewRow();
*};

